global script_node
local anim_name_internal
local audio_time_internal

global function PlayAnim(anim_name, audio_time)
	anim_name_internal = anim_name
	audio_time_internal = audio_time
	RunAsync(script_node, "PlayAnimInternal")
end

global function PlayAnimInternal()
	local sonic_prop = script_node:FindProp()
	local sonic_entity = sonic_prop:GetTransform()
	local sonic_anim = FindNodeByShortName(anim_name_internal)
	local sonic_audio = sonic_prop:FindNodeByTag("audio")
	local anim_time = sonic_anim:GetDuration()
	
	sonic_prop:PlayAnim(sonic_anim, 1, 0)
	Wait(0.5)
	sonic_entity:Show()
	Wait(audio_time_internal + 0.3)
	sonic_audio:Trigger()
	Wait(1.0)
	sonic_audio:StopTrigger()
	Wait(anim_time - audio_time_internal - 1.5)
	sonic_entity:Hide()
end
